/*
 * Decompiled with CFR 0.152.
 */
package com.sinaflying.glogo;

import com.sinaflying.customise.Function;
import com.sinaflying.customise.R;
import com.sinaflying.engine.GameMIDlet;
import com.sinaflying.game.GameInterface;
import com.sinaflying.glogo.LogoListener;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Logo {
    private int _status;
    private LogoListener _listener;
    private int _gameRank;
    private int screenWidth;
    private int screenHeight;
    private Image title;
    private Image cmcc;
    private Image star0;
    private Image star1;
    private Image soundask;
    private Image transImg1 = null;
    private Image transImg2 = null;
    private Image bg = null;
    private Image[] logo;
    private int _soundModel;
    GameMIDlet _mid;
    boolean _isFinish = false;
    String _path = "/res";
    private int _ticks = 0;
    private static int sleeptime = 40;
    private int index = 0;
    private int[] widoff = new int[]{35, 88, 140};
    private int[] heioff0 = new int[]{16, 14, 5, 1, -3, -2, 2};
    private int[] heioff1 = new int[]{18, 15, -2, 0};
    private int[][] logoInfo = new int[][]{{2, this.heioff0[2], 0, this.heioff0[2], 1, this.heioff0[2], sleeptime}, {2, this.heioff0[1], 0, this.heioff0[1], 1, this.heioff0[1], sleeptime}, {2, this.heioff0[0], 0, this.heioff0[0], 1, this.heioff0[0], sleeptime}, {-1, this.heioff1[0], -1, this.heioff1[0], -1, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[0], -1, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[1], -1, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[2], -1, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[3], -1, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[0], -1, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[1], 5, this.heioff1[0], sleeptime}, {-1, this.heioff1[0], 5, this.heioff1[2], 5, this.heioff1[1], sleeptime}, {5, this.heioff1[0], 5, this.heioff1[3], 5, this.heioff1[2], sleeptime}, {5, this.heioff1[1], 5, this.heioff1[0], 5, this.heioff1[3], sleeptime}, {5, this.heioff1[2], 5, this.heioff1[1], 5, this.heioff1[0], sleeptime}, {5, this.heioff1[3], 5, this.heioff1[2], 5, this.heioff1[1], sleeptime}, {5, this.heioff1[0], 5, this.heioff1[3], 5, this.heioff1[2], sleeptime}, {5, this.heioff1[1], 5, this.heioff1[0], 5, this.heioff1[3], sleeptime}, {5, this.heioff1[2], 2, this.heioff0[0], 5, this.heioff1[0], sleeptime}, {5, this.heioff1[3], 2, this.heioff0[1], 5, this.heioff1[1], sleeptime}, {5, this.heioff1[0], 2, this.heioff0[2], 5, this.heioff1[2], sleeptime}, {5, this.heioff1[1], 2, this.heioff0[3], 5, this.heioff1[3], sleeptime}, {5, this.heioff1[2], 2, this.heioff0[4], 5, this.heioff1[0], sleeptime}, {5, this.heioff1[3], 2, this.heioff0[5], 5, this.heioff1[1], sleeptime}, {3, this.heioff0[0], 2, this.heioff0[6], 5, this.heioff1[2], sleeptime}, {3, this.heioff0[1], 2, this.heioff0[6], 5, this.heioff1[3], sleeptime}, {3, this.heioff0[2], 2, this.heioff0[6], 5, this.heioff1[0], sleeptime}, {3, this.heioff0[3], 2, this.heioff0[6], 5, this.heioff1[1], sleeptime}, {3, this.heioff0[4], 2, this.heioff0[6], 5, this.heioff1[2], sleeptime}, {3, this.heioff0[5], 2, this.heioff0[6], 5, this.heioff1[3], sleeptime}, {4, this.heioff0[0], 2, this.heioff0[6], 3, this.heioff0[6], sleeptime}, {4, this.heioff0[1], 2, this.heioff0[6], 3, this.heioff0[6], sleeptime}, {4, this.heioff0[2], 2, this.heioff0[6], 3, this.heioff0[6], sleeptime}, {4, this.heioff0[6], 2, this.heioff0[6], 3, this.heioff0[6], 1000}};

    public static Logo createLogos(int n, LogoListener logoListener, int n2, int n3, int n4, GameMIDlet gameMIDlet) {
        Logo logo = new Logo(n, logoListener, n2, n3, n4, gameMIDlet);
        return logo;
    }

    private Logo(int n, LogoListener logoListener, int n2, int n3, int n4, GameMIDlet gameMIDlet) {
        this._gameRank = n;
        this._listener = logoListener;
        this._status = 0;
        this.screenWidth = n3;
        this.screenHeight = n4;
        this._soundModel = n2;
        this._mid = gameMIDlet;
    }

    private void processSoundKey(int n) {
        switch (n) {
            case 65536: {
                Function.startupSound(true, 2);
                this._status = 3;
                this._ticks = 60;
                break;
            }
            case 131072: {
                Function.startupSound(false, 2);
                GameInterface._soundSize = 0;
                this._status = 3;
                this._ticks = 60;
            }
        }
    }

    private void draw(Graphics graphics) {
        switch (this._status) {
            case 0: {
                this.paintGameLogo(graphics);
                break;
            }
            case 1: {
                this.paintGameLogo(graphics);
                break;
            }
            case 2: {
                this.paintSound(graphics);
                this.processSoundKey(this._listener.getKeyStatus());
                break;
            }
            case 3: {
                this.paintLogo(graphics);
                if (this._ticks != 65) break;
                this._status = 4;
                Function.playSound(7, 1);
                break;
            }
            case 4: {
                if (++this.index >= this.logoInfo.length) {
                    this._status = 5;
                    this._ticks = 100;
                    return;
                }
                this.paintEffect(graphics);
                break;
            }
            case 5: {
                ++this._ticks;
                if (this._ticks != 110) break;
                this.setFinish();
            }
        }
    }

    public void clearUp() {
        this.title = null;
        this.cmcc = null;
        this.star0 = null;
        this.star1 = null;
        this.soundask = null;
        this.transImg1 = null;
        this.transImg2 = null;
        this.bg = null;
        this.logo = null;
    }

    private void setFinish() {
        this._isFinish = true;
        this.clearUp();
    }

    public boolean getIfFinish() {
        return this._isFinish;
    }

    private void init() {
        try {
            this.cmcc = R.loadPng("/res/logoPng.bin", 0);
            this.soundask = R.loadPng("/res/logoPng.bin", 1);
            this.bg = R.loadPng("/res/logoPng.bin", 2);
            this.logo = new Image[6];
            int n = 0;
            while (n < 6) {
                this.logo[n] = R.loadPng("/res/logoPng.bin", 5 + n);
                ++n;
            }
            this.transImg1 = R.loadPng("/res/logoPng.bin", 11);
            this.transImg2 = R.loadPng("/res/logoPng.bin", 12);
            this.title = R.loadPng("/res/logoPng.bin", 13);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void paintRank(Graphics graphics) {
        int n;
        int n2;
        int n3 = this.cmcc.getWidth();
        int n4 = this.cmcc.getHeight();
        if (this.screenWidth == 240) {
            n2 = 30;
            n = 67;
            int n5 = 6;
        } else if (this.screenWidth == 176) {
            n2 = 22;
            n = 108;
            int n6 = 2;
        } else if (this.screenWidth == 208) {
            n2 = 28;
            n = 108;
            int n7 = 4;
        } else if (this.screenWidth == 320) {
            n2 = 75;
            n = 30;
            int n8 = 4;
        } else {
            n2 = 22;
            n = 108;
            int n9 = 2;
        }
        graphics.drawImage(this.cmcc, n2, n, 20);
        graphics.drawImage(this.logo[2], this.screenWidth / 2, n + this.cmcc.getHeight() + 10, 17);
    }

    private void paintGameLogo(Graphics graphics) {
        graphics.setColor(14, 18, 11);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        int n = this.screenWidth >> 1;
        int n2 = this.screenHeight / 3;
        if (this._gameRank > 0) {
            this.paintRank(graphics);
        }
    }

    private void paintSound(Graphics graphics) {
        this.paintGameLogo(graphics);
        graphics.drawImage(this.soundask, this.screenWidth - this.soundask.getWidth() >> 1, this.screenHeight, 36);
    }

    private void paintBkGrd(Graphics graphics) {
        int n = this.screenWidth == 240 ? 55 : (this.screenWidth == 320 ? 15 : 0);
        graphics.setClip(0, 0, this.screenWidth, this.screenHeight);
        graphics.setColor(14, 18, 11);
        graphics.fillRect(0, 0, this.screenWidth, this.screenHeight);
        graphics.drawImage(this.bg, this.screenWidth >> 1, n, 17);
    }

    private void paintLogo(Graphics graphics) {
        this.paintBkGrd(graphics);
        graphics.drawImage(this.logo[2], this.screenWidth / 2 - 52, this.screenHeight / 2, 3);
        graphics.drawImage(this.logo[0], this.screenWidth / 2, this.screenHeight / 2, 3);
        graphics.drawImage(this.logo[1], this.screenWidth / 2 + 50, this.screenHeight / 2, 3);
    }

    private void paintEffect(Graphics graphics) {
        this.paintBkGrd(graphics);
        this.drawLogo(graphics);
    }

    public void paint(Graphics graphics) {
        ++this._ticks;
        if (this._ticks == 1) {
            this.init();
            this._status = 1;
        } else if (this._ticks == 30) {
            this._status = 2;
        }
        this.draw(graphics);
    }

    private void drawLogo(Graphics graphics) {
        int n = this.screenWidth - 176 >> 1;
        int n2 = 0;
        n2 = this.screenWidth == 240 ? 52 : (this.screenWidth == 320 ? 12 : 0);
        int n3 = 0;
        while (n3 < 3) {
            if (this.logoInfo[this.index][n3 * 2] != -1) {
                int n4 = this.widoff[n3];
                if (this.logoInfo[this.index][n3 * 2] == 3) {
                    n4 = this.widoff[0];
                } else if (this.logoInfo[this.index][n3 * 2] == 4) {
                    n4 = this.widoff[2];
                }
                if (this.logoInfo[this.index][n3 * 2] == 5) {
                    int[] nArray = new int[]{0, -1, -1};
                    if (this.logoInfo[this.index][n3 * 2 + 1] == this.heioff1[0]) {
                        graphics.drawImage(this.transImg1, n4 + n + nArray[n3], n2 + 73, 17);
                    } else if (this.logoInfo[this.index][n3 * 2 + 1] == this.heioff1[1]) {
                        graphics.drawImage(this.logo[this.logoInfo[this.index][n3 * 2]], n + n4, n2 + 100, 3);
                    } else if (this.logoInfo[this.index][n3 * 2 + 1] == this.heioff1[2]) {
                        graphics.drawImage(this.transImg2, n + n4 + nArray[n3], n2 + 72, 17);
                    }
                } else {
                    graphics.drawImage(this.logo[this.logoInfo[this.index][n3 * 2]], n + n4, n2 + this.logoInfo[this.index][n3 * 2 + 1] + 100, 3);
                }
            }
            ++n3;
        }
    }
}

